package OOPLS;
import java.awt.Graphics;
import javax.swing.JPanel;
import java.awt.Rectangle;
import java.awt.Point;

public class CompleteGraphPanel extends JPanel {
    int n;
    public CompleteGraphPanel(int initialN) {
        setNumVertices(initialN);
    }
    public CompleteGraphPanel() {
        this(3);
    }
    public int getNumVertices() { return n; }
    public void setNumVertices(int n) {
        this.n = n>=3?n:3;
    }
    public void paint(Graphics g) {
        super.paint(g);
        Rectangle rect = g.getClipBounds();
        Point center = new Point(rect.x+rect.width/2, 
            rect.y+rect.height/2);
        int radius = Math.min(rect.width/2, rect.height/2);
        Point p[] = new Point[n];
        for (int i = 0; i<n; ++i) {
            double theta = 2*i*Math.PI/n;
            p[i] = new Point(
                (int)(center.x+radius*Math.cos(theta)),
                (int)(center.y+radius*Math.sin(theta)));
        }
        for (int i = 0; i<n; ++i) {
            for (int j=i+1; j<n; ++j)
                g.drawLine(p[i].x,p[i].y,p[j].x,p[j].y);
        }
        g.drawString(n + " vertices", 15, 15);
    }

}
